﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMTPS.pas' rev: 37.00 (Windows)

#ifndef SMTPSHPP
#define SMTPSHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <System.SysUtils.hpp>
#include <SMCells.hpp>
#include <SMClarion.hpp>
#include <System.Types.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smtps
{
//-- forward type declarations -----------------------------------------------
struct TTPSHeader;
struct TTPSPageHeader;
class DELPHICLASS TTPSField;
class DELPHICLASS TTPSFields;
class DELPHICLASS TTPSKeyItem;
class DELPHICLASS TTPSKeyItems;
class DELPHICLASS TTPSKey;
class DELPHICLASS TTPSKeys;
struct TTPSRecordHeader;
class DELPHICLASS TTPSRecordBody;
class DELPHICLASS TTPSRecordDataBody;
class DELPHICLASS TTPSRecordMetaDataBody;
class DELPHICLASS TTPSRecordTableDefinitionBody;
class DELPHICLASS TTPSRecordMemoBody;
class DELPHICLASS TTPSRecordTableNameBody;
class DELPHICLASS TTPSRecordIndexBody;
class DELPHICLASS TTPSRecord;
class DELPHICLASS TTPSRecords;
struct TTPSTableHeader;
class DELPHICLASS TTPSClarionTable;
class DELPHICLASS TClarionTPS;
//-- type declarations -------------------------------------------------------
#pragma pack(push,1)
struct DECLSPEC_DRECORD TTPSHeader
{
public:
	unsigned Address;
	System::Word HeaderSize;
	unsigned FileLength1;
	unsigned FileLength2;
	System::StaticArray<char, 4> Signature;
	System::Word Zeros;
	unsigned LastIssuedRow;
	unsigned Changes;
	unsigned ManagementPageRef;
	System::StaticArray<unsigned, 60> PageStart;
	System::StaticArray<unsigned, 60> PageEnd;
};
#pragma pack(pop)


#pragma pack(push,1)
struct DECLSPEC_DRECORD TTPSPageHeader
{
public:
	unsigned Address;
	System::Word PageSize;
	System::Word UncompressedSize;
	System::Word UncompressedWithoutHeader;
	System::Word RecordCount;
	System::Byte Flags;
};
#pragma pack(pop)


enum DECLSPEC_DENUM TTPSFieldType : unsigned char { tftUnknown, tftByte, tftShort, tftUShort, tftDate, tftTime, tftLong, tftULong, tftFloat, tftDouble, tftDecimal, tftChar, tftVarChar, tftPicString, tftGroup, tftMemo, tftBLOB, tftSubGroup };

typedef System::StaticArray<System::UnicodeString, 18> Smtps__1;

typedef System::RawByteString TTPSByteArray;

#pragma pack(push,4)
class PASCALIMPLEMENTATION TTPSField : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
public:
	System::Byte FieldType;
	System::UnicodeString FieldName;
	System::Word StartPos;
	System::Word Length;
	System::Word Flags;
	System::Word Index;
	System::Byte Decimals;
	System::Byte Precision;
	System::Word StringSize;
	System::UnicodeString StringPicture;
	System::Word ArrayNum;
	System::UnicodeString ExternalFileName;
	bool __fastcall IsArrayField();
	void __fastcall ParseFieldValue(const TTPSByteArray Data, int APos, System::Variant &Value, Smcells::TSMICellType &CellType);
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TTPSField() { }
	
public:
	/* TObject.Create */ inline __fastcall TTPSField() : System::Classes::TPersistent() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TTPSFields : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
public:
	__fastcall virtual ~TTPSFields();
	void __fastcall RemoveField(int i);
	virtual void __fastcall Clear();
public:
	/* TObject.Create */ inline __fastcall TTPSFields() : System::Classes::TList() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TTPSKeyItem : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
public:
	System::Word Field;
	System::Word Flags;
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TTPSKeyItem() { }
	
public:
	/* TObject.Create */ inline __fastcall TTPSKeyItem() : System::Classes::TPersistent() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TTPSKeyItems : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
public:
	__fastcall virtual ~TTPSKeyItems();
	void __fastcall RemoveKey(int i);
	virtual void __fastcall Clear();
public:
	/* TObject.Create */ inline __fastcall TTPSKeyItems() : System::Classes::TList() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TTPSKey : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
public:
	System::UnicodeString ExternalFileName;
	System::UnicodeString KeyName;
	System::Byte Flags;
	System::Word FieldNum;
	TTPSKeyItems* Items;
	__fastcall virtual TTPSKey();
	__fastcall virtual ~TTPSKey();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	System::UnicodeString __fastcall GetTypeStr(bool IncludeHexType);
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TTPSKeys : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
public:
	__fastcall virtual ~TTPSKeys();
	void __fastcall RemoveKey(int i);
	virtual void __fastcall Clear();
public:
	/* TObject.Create */ inline __fastcall TTPSKeys() : System::Classes::TList() { }
	
};

#pragma pack(pop)

#pragma pack(push,1)
struct DECLSPEC_DRECORD TTPSRecordHeader
{
public:
	System::Byte Flags;
	System::Word RecordLength;
	System::Word HeaderLength;
};
#pragma pack(pop)


#pragma pack(push,4)
class PASCALIMPLEMENTATION TTPSRecordBody : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	virtual void __fastcall LoadHeaderFromData(TTPSByteArray Data, int &APos, const TTPSRecordHeader &Header);
	virtual void __fastcall LoadBodyFromData(TTPSByteArray Data, int &APos, const TTPSRecordHeader &Header);
public:
	/* TObject.Create */ inline __fastcall TTPSRecordBody() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TTPSRecordBody() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TTPSRecordDataBody : public TTPSRecordBody
{
	typedef TTPSRecordBody inherited;
	
public:
	unsigned RecordNumber;
	virtual void __fastcall LoadHeaderFromData(TTPSByteArray Data, int &APos, const TTPSRecordHeader &Header);
public:
	/* TObject.Create */ inline __fastcall TTPSRecordDataBody() : TTPSRecordBody() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TTPSRecordDataBody() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TTPSRecordMetaDataBody : public TTPSRecordBody
{
	typedef TTPSRecordBody inherited;
	
public:
	System::Byte AboutType;
	virtual void __fastcall LoadHeaderFromData(TTPSByteArray Data, int &APos, const TTPSRecordHeader &Header);
public:
	/* TObject.Create */ inline __fastcall TTPSRecordMetaDataBody() : TTPSRecordBody() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TTPSRecordMetaDataBody() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TTPSRecordTableDefinitionBody : public TTPSRecordBody
{
	typedef TTPSRecordBody inherited;
	
private:
	TTPSFields* FFields;
	TTPSKeys* FKeys;
	
public:
	System::Word Block;
	System::Word DriverVersion;
	System::Word RecordSize;
	System::Word NumberOfFields;
	System::Word NumberOfMemos;
	System::Word NumberOfKeys;
	__fastcall virtual TTPSRecordTableDefinitionBody();
	__fastcall virtual ~TTPSRecordTableDefinitionBody();
	virtual void __fastcall LoadHeaderFromData(TTPSByteArray Data, int &APos, const TTPSRecordHeader &Header);
	virtual void __fastcall LoadBodyFromData(TTPSByteArray Data, int &APos, const TTPSRecordHeader &Header);
	__property TTPSFields* Fields = {read=FFields, write=FFields};
	__property TTPSKeys* Keys = {read=FKeys, write=FKeys};
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TTPSRecordMemoBody : public TTPSRecordBody
{
	typedef TTPSRecordBody inherited;
	
public:
	unsigned ParentRecord;
	System::Byte MemoIndex;
	System::Word SequenceNo;
	unsigned UniqueID;
	virtual void __fastcall LoadHeaderFromData(TTPSByteArray Data, int &APos, const TTPSRecordHeader &Header);
	System::UnicodeString __fastcall GetValue(int ALength, int AStartPos, TTPSByteArray Data);
public:
	/* TObject.Create */ inline __fastcall TTPSRecordMemoBody() : TTPSRecordBody() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TTPSRecordMemoBody() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TTPSRecordTableNameBody : public TTPSRecordBody
{
	typedef TTPSRecordBody inherited;
	
public:
	System::UnicodeString TableName;
	unsigned TableNumber;
	virtual void __fastcall LoadHeaderFromData(TTPSByteArray Data, int &APos, const TTPSRecordHeader &Header);
public:
	/* TObject.Create */ inline __fastcall TTPSRecordTableNameBody() : TTPSRecordBody() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TTPSRecordTableNameBody() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TTPSRecordIndexBody : public TTPSRecordBody
{
	typedef TTPSRecordBody inherited;
	
public:
	unsigned IndexNumber;
	unsigned RecordNumber;
	virtual void __fastcall LoadHeaderFromData(TTPSByteArray Data, int &APos, const TTPSRecordHeader &Header);
public:
	/* TObject.Create */ inline __fastcall TTPSRecordIndexBody() : TTPSRecordBody() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TTPSRecordIndexBody() { }
	
};

#pragma pack(pop)

enum DECLSPEC_DENUM TTPSRecordType : unsigned char { rtUnknown, rtData, rtMetaData, rtTableDefinition, rtMemo, rtTableName, rtIndex };

#pragma pack(push,4)
class PASCALIMPLEMENTATION TTPSRecord : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	int Index;
	TTPSRecordHeader Header;
	TTPSRecordBody* Body;
	TTPSByteArray Data;
	unsigned TableNumber;
	System::Byte RecordType;
	__fastcall virtual ~TTPSRecord();
	TTPSRecordType __fastcall GetRecordType();
public:
	/* TObject.Create */ inline __fastcall TTPSRecord() : System::TObject() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TTPSRecords : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
public:
	__fastcall virtual ~TTPSRecords();
	void __fastcall RemoveRecord(int i);
	virtual void __fastcall Clear();
	int __fastcall BinarySearch(unsigned ATableNumber, System::Byte AMemoIndex, unsigned ARecNumber);
	TTPSRecord* __fastcall FindRecordByType(unsigned TableNumber, TTPSRecordType RecordType);
	int __fastcall AddIndex(int AIndex, void * Value);
public:
	/* TObject.Create */ inline __fastcall TTPSRecords() : System::Classes::TList() { }
	
};

#pragma pack(pop)

#pragma pack(push,1)
struct DECLSPEC_DRECORD TTPSTableHeader
{
public:
	System::Word DriverVersion;
	System::Word RecordSize;
	System::Word NumberOfFields;
	System::Word NumberOfMemos;
	System::Word NumberOfKeys;
};
#pragma pack(pop)


class PASCALIMPLEMENTATION TTPSClarionTable : public Smcells::TSpreadSheet
{
	typedef Smcells::TSpreadSheet inherited;
	
private:
	TTPSFields* FFields;
	TTPSKeys* FKeys;
	
public:
	TTPSTableHeader DBHeader;
	Smclarion::TClarionFieldLinks* FieldHiearachy;
	__fastcall virtual TTPSClarionTable(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TTPSClarionTable();
	void __fastcall CopyAttributes(TTPSRecordTableDefinitionBody* tdb);
	
__published:
	__property TTPSFields* Fields = {read=FFields, write=FFields};
	__property TTPSKeys* Keys = {read=FKeys, write=FKeys};
};


class PASCALIMPLEMENTATION TClarionTPS : public Smclarion::TCustomClarion
{
	typedef Smclarion::TCustomClarion inherited;
	
private:
	TTPSTableHeader __fastcall GetDBHeader();
	TTPSField* __fastcall GetFields(int Index);
	TTPSKeys* __fastcall GetKeys();
	int __fastcall GetTableNumber();
	void __fastcall SetTableNumber(int AValue);
	Smclarion::TClarionFieldLinks* __fastcall GetFieldHiearachy();
	void __fastcall MergeTableDefinitions();
	
protected:
	System::Classes::TStream* FCurrentStream;
	TTPSRecords* lstTPSRecords;
	TTPSRecords* lstTPSMemoRecords;
	void __fastcall UnPackCompressed(System::Classes::TStream* Compressed, int DataLen, System::Classes::TMemoryStream* &Decompressed);
	void __fastcall ClearEmptySheets();
	void __fastcall ReadBLOBValueFromRecord(unsigned ATableNumber, System::Byte AMemoIndex, unsigned ARecNumber, System::UnicodeString &s);
	virtual void __fastcall ReadBLOBValue(unsigned BlockNo, unsigned ASize, System::UnicodeString &s);
	System::UnicodeString __fastcall GetSplittedFieldName(int ArrayItemIndex, const System::UnicodeString strFieldName);
	
public:
	TTPSHeader FileHeader;
	__fastcall virtual TClarionTPS(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TClarionTPS();
	virtual void __fastcall LoadFromStream(System::Classes::TStream* AStream);
	virtual void __fastcall LoadFromFile(const System::WideString FileName);
	virtual void __fastcall BeforeLoad();
	virtual void __fastcall AfterLoad();
	virtual int __fastcall FindColumn(const System::UnicodeString AFieldName);
	virtual void __fastcall FillColumnList(System::Classes::TStrings* lst, const System::UnicodeString strFieldList);
	virtual System::UnicodeString __fastcall GetStrFieldType(System::Byte AType);
	virtual void __fastcall RenameFieldName(int FieldIndex, const System::UnicodeString FieldName);
	void __fastcall CreateDictionaryFile(const System::UnicodeString AFileName);
	void __fastcall ClearEmptySheetCells(Smcells::TSpreadSheetCells* ACells);
	__property TTPSTableHeader DBHeader = {read=GetDBHeader};
	__property TTPSField* Fields[int Index] = {read=GetFields};
	__property TTPSKeys* Keys = {read=GetKeys};
	__property Smclarion::TClarionFieldLinks* FieldHiearachy = {read=GetFieldHiearachy};
	
__published:
	__property int TableNumber = {read=GetTableNumber, write=SetTableNumber, default=0};
};


//-- var, const, procedure ---------------------------------------------------
extern DELPHI_PACKAGE Smtps__1 arrClarionTPSFieldTypeStr;
extern DELPHI_PACKAGE TTPSFieldType __fastcall GetTopSpeedFieldType(System::Byte AType);
}	/* namespace Smtps */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMTPS)
using namespace Smtps;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMTPSHPP
